<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Listagem de Vídeos</h3>
            <a href="<?php echo e(route('videos.create')); ?>" class="btn btn-primary float-right">Criar Novo Vídeo</a>
        </div>
        <div class="card-body">
          
            <table id="videos" class="table table-striped-columns">
                <thead>
                    <tr>
                        <th>Título</th>
                        <th>Descrição</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($video->title); ?></td>
                        <td><?php echo e($video->description); ?></td>
                        <td>
                            <a href="<?php echo e(route('videos.show', $video->id)); ?>" class="btn btn-info">
                            <i class="fa fa-eye" aria-hidden="true"></i>
                            </a>
                            <a href="<?php echo e(route('videos.edit', $video->id)); ?>" class="btn btn-warning">
                            <i class="fa fa-pencil" aria-hidden="true"></i>
                            </a>
                            <form action="<?php echo e(route('videos.destroy', $video->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger">
                                <i class="fa-solid fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<style>

#videos_filter input {
    display: block;
    width: 100%;
    height: calc(1.5em + .75rem + 2px);
    padding: .375rem .75rem;
    font-size: 1rem;
    font-weight: 400;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da !important;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
}
.dataTables_paginate a{
    padding:5px;
    background:#007bff;
    color:#fff;
    margin-right:10px;
    cursor:pointer;
    margin-top:10px;
}

#videos_length select {
   
        background-position-x: 0%;
        background-position-y: 0%;
        color:#000;
    background-position: 205px center;
    width: 270px;
    height: 48px;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 18px;
    padding: 13px 20px 13px 12px;

    text-indent: 0.01px;
    text-overflow: "";
    select: :-ms-expand {display: none;};
}
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" src="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
	   
	 
<script type="text/javascript" language="javascript" class="init">
var j = jQuery.noConflict();
j(document).ready(function() {
	j('#videos').dataTable({
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados por página",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sunstonecom/public_html/meercat.sunstone.com.br/meercat/resources/views/videos/index.blade.php ENDPATH**/ ?>