<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PhotoController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\PlaylistController;
use App\Http\Controllers\ScheduleController;
use App\Http\Controllers\VideosController;
use App\Models\Schedule;
use App\Models\Videos;
use App\Models\Photo;
use App\Models\Playlist;
use App\Models\News;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/greeting', function () {
    return 'Hello World';
});

Route::get('/', function () {

    $schedules = Schedule::where('deleted', false)->get();
    $videos = Videos::where('deleted', false)->get();
    $playlists = Playlist::where('deleted', false)->limit(2)->get();
    $photos = Photo::where('deleted', false)->get();
    $news = News::where('deleted', false)->get();
    return view('welcome', compact('schedules', 'videos', 'playlists', 'photos', 'news'));
});



Route::get('api/v1/photos', [PhotoController::class, 'getPhotos']);
Route::get('api/v1/photo/{id}', [PhotoController::class, 'getPhoto']);

Route::get('api/v1/events', [ScheduleController::class, 'getEvents']);
Route::get('api/v1/event/{id}', [ScheduleController::class, 'getEvent']);

Route::get('api/v1/news', [NewsController::class, 'getNews']);
Route::get('api/v1/news/{id}', [NewsController::class, 'getNews']);

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');



    /* CONTROLLER news */
    Route::resource('news', NewsController::class);
    //Route::post('news/create', [NewsController::class, 'create']);




    /* CONTROLLER playlist */
    Route::resource('playlist', PlaylistController::class);
    //Route::post('playlist/create', [PlaylistController::class, 'create']);


    Route::post('/music', [PlaylistController::class, 'music'])->name('music.views');
    Route::get('/download/{id}', [PlaylistController::class, 'download'])->name('music.download');

    /* CONTROLLER schedule (EVENTOS) */
    Route::resource('schedule', ScheduleController::class);
    Route::post('schedule/create', [ScheduleController::class, 'create']);

    /* CONTROLLER PHOTOS */
    Route::resource('photo', PhotoController::class);
    //Route::post('photo/create', [PhotoController::class, 'create']);

    /* CONTROLLER videos */
    Route::resource('videos', VideosController::class);
});


Route::get('category/news/{id}', function ($id) {

    $new = News::findOrFail($id);;

    return view('news', compact('new'));
});


Route::get('category/event/{id}', function ($id) {

    $event = Schedule::findOrFail($id);;

    return view('events', compact('event'));
});


require __DIR__ . '/auth.php';
