<!-- resources/views/photos/create.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Carregar Nova Foto</h3>
        </div>
        <div class="card-body">
          
            <form id="photos-form" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" placeholder="Título da foto" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" placeholder="Descrição da foto" rows="5" required></textarea>
                </div>
                
                <div class="form-group">
                    <label for="image">Escolher Imagem</label>
                    <input type="file" name="image" class="form-control-file" required>
                </div>
                
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn-success">Salvar 
                        <div class="spinner" style="visibility: hidden;"></div>
                    </button>
                    <a href="{{ route('photo.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
               
            </form>
        </div>
    </div>
</div>
<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
  
    $('#photos-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: "{{ route('photo.store') }}", // Rota para criar a foto
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Foto carregada com sucesso.</div>');
             window.location.href = "{{ route('photo.index') }}";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao carregar a foto.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao carregar foto. Tente novamente mais tarde.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
@endsection
