<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Photo extends Model
{
    use HasFactory;

    protected $table = 'photos';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

	protected $fillable = [
        'title',
        'description',
        'deleted',
        'users_id',
        'image'
    ];
}

/*
CREATE TABLE photos (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  users_id INTEGER UNSIGNED NOT NULL,
  title VARCHAR(100) NULL,
  description VARCHAR(500) NULL,
  deleted CHAR(1) NULL,
  image TEXT NULL,
  updated_at TIMESTAMP NULL,
  created_at TIMESTAMP NULL,
  PRIMARY KEY(id),
  INDEX photos_FKIndex1(users_id)
);
*/