<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class News extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

	protected $fillable = [
        'title',
        'description',
        'deleted',
        'users_id',
        'image'
    ];

    protected $table = 'news';

    protected $timestamp = true;
}

/*
  CREATE TABLE news (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  users_id INTEGER UNSIGNED NOT NULL,
  title VARCHAR(100) NULL,
  description TEXT NULL,
  updated_at TIMESTAMP NULL,
  image TEXT NULL,
  deleted CHAR(1) NULL,
  created_at TIMESTAMP NULL,
  PRIMARY KEY(id),
  INDEX news_FKIndex1(users_id)
);

*/