<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Criar Novo Vídeo</h3>
        </div>
        <div class="card-body">
            <form id="videos-form" action="<?php echo e(route('videos.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" rows="5"></textarea>
                </div>
                <div class="form-group">
                    <label for="embled">Código Embed</label>
                    <textarea name="embled" class="form-control" rows="3" required></textarea>
                </div>
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit"class="btn btn-success">Salvar 
                        <span class="spinner" style="visibility: hidden;"></span>
                    </button>
                    <a href="<?php echo e(route('videos.index')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>    
            </form>
     
        </div>
    </div>
</div>

<style>
    .spinner {
        width: 20px;
        height: 20px;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top: 3px solid #fff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-right: 8px;
        display: inline-block;
        vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .btn-primary, .btn-warning {
        display: inline-flex;
        align-items: center;
    }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#videos-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: $(this).attr('action'), 
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Vídeo criado com sucesso.</div>');
                window.location.href = "<?php echo e(route('videos.index')); ?>";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao criar o vídeo.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao criar o vídeo. Tente novamente mais tarde.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sunstonecom/public_html/meercat.sunstone.com.br/meercat/resources/views/videos/create.blade.php ENDPATH**/ ?>