@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Editar Vídeo</h3>
        </div>
        <div class="card-body">
            <form id="videos-form" action="{{ route('videos.update', $video->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" value="{{ $video->title }}" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" rows="5">{{ $video->description }}</textarea>
                </div>
                <div class="form-group">
                    <label for="embled">Código Embled</label>
                    <textarea name="embled" class="form-control" rows="3" required>{{ $video->embled }}</textarea>
                </div>
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn btn-success">
                         Atualizar Vídeo
                         <span class="spinner" style="visibility: hidden;"></span>
                    </button>
                    <a href="{{ route('videos.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>    
            </form>
       
        </div>
    </div>
</div>

<style>
    .spinner {
        width: 20px;
        height: 20px;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top: 3px solid #fff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-right: 8px;
        display: inline-block;
        vertical-align: middle;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .btn-primary, .btn-warning {
        display: inline-flex;
        align-items: center;
    }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#videos-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: $(this).attr('action'), 
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Vídeo atualizado com sucesso.</div>');
                window.location.href = "{{ route('videos.index') }}";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao atualizar o vídeo.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao atualizar o vídeo. Tente novamente mais tarde.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
@endsection
