<!-- resources/views/schedule/edit.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Editar Evento</h3>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="schedule-form" action="{{ route('schedule.update', $schedule->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title', $schedule->title) }}" required>
                </div>
                <div class="form-group">
                    <label for="title">Local do evento</label>
                    <input type="text"  name="location" class="form-control" value="{{ old('location', $schedule->location) }}" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" rows="5" required>{{ old('description', $schedule->description) }}</textarea>
                </div>
                <div class="form-group">
                    <label for="date">Data</label>
                    <input type="datetime-local" name="date" class="form-control" value="{{ old('date', \Carbon\Carbon::parse($schedule->date)->format('Y-m-d\TH:i')) }}" required>
                </div>
                <div class="form-group">
                    <label for="image">Imagem (opcional)</label>
                    <input type="file" name="image" class="form-control-file">
                </div>
                @if ($schedule->image)
                    <div class="form-group">
                        <p><strong>Imagem Atual:</strong></p>
                        <img src="{{ asset('storage/' . $schedule->image) }}" width="100">
                    </div>
                @endif
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn btn-success">
                    Atualizar Evento
                    <span class="spinner" style="visibility: hidden;"></span>
                    </button>
                    <a href="{{ route('schedule.index') }}" class="btn btn-secondary">Cancelar</a>
               </div>    
            </form>
           
        </div>
    </div>
</div>

<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
 
    $('#schedule-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: "{{ route('schedule.update', $schedule->id) }}", // Rota para editar o agendamento
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Evento atualizado com sucesso.</div>');
                window.location.href = "{{ route('schedule.index') }}";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao atualizar o Evento.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao atualizar o Evento. Tente novamente mais tarde.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
@endsection
