<!-- resources/views/schedule/create.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Criar Novo Agendamento</h3>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="schedule-form" action="{{ route('schedule.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                </div>
                <div class="form-group">
                    <label for="title">Local do evento</label>
                    <input type="text" required name="location" class="form-control" value="{{ old('location') }}" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description"  class="form-control" rows="5" required>{{ old('description') }}</textarea>
                </div>
                <div class="form-group">
                    <label for="date">Data</label>
                    <input type="datetime-local" name="date" class="form-control" value="{{ old('date') }}" required>
                </div>
                <div class="form-group">
                    <label for="image">Imagem (opcional)</label>
                    <input type="file" name="image" class="form-control-file">
                </div>
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn-success">
                       Salvar   <span class="spinner" style="visibility: hidden;"></span>
                    </button>
                    <a href="{{ route('schedule.index') }}" class="btn btn-secondary">Cancelar</a>
                 </div>
            </form>
           
        </div>
    </div>
    <style>
    .spinner {
        width: 20px;
        height: 20px;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top: 3px solid #fff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-right: 8px;
        display: inline-block;
        vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .btn-primary, .btn-warning {
        display: inline-flex;
        align-items: center;
    }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {

    $('#schedule-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: "{{ route('schedule.store') }}", // Rota para criar o agendamento
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Agendamento criado com sucesso.</div>');
                window.location.href = "{{ route('schedule.index') }}";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao criar o agendamento.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao criar o agendamento. Tente novamente mais tarde.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
@endsection
