<!-- resources/views/playlist/index.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
     <!-- Mensagem de Sucesso -->
     @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    <div class="card">
        <div class="card-header">
            <h3>Lista de Playlists</h3>
            <a href="{{ route('playlist.create') }}" class="btn btn-primary float-right">Criar Nova Playlist</a>
        </div>
        <div class="card-body">
            <table id="playlist" class="table table-striped-columns">
                <thead>
                    <tr>
                        <th>Título <i class="fa fa-sort" aria-hidden="true"></i></th>
                        <th>Descrição <i class="fa fa-sort" aria-hidden="true"></i></th>
                        <th>Data de Criação <i class="fa fa-sort" aria-hidden="true"></i></th>
                        <th>Ações <i class="fa fa-sort" aria-hidden="true"></i></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($playlists as $item)
                        <tr>
                            <td>{{ $item->title }}</td>
                            <td>{{ Str::limit($item->description, 100) }}</td>
                            <td>{{ $item->created_at->format('d/m/Y') }}</td>
                            <td>
                                <a href="{{ route('playlist.show', $item->id) }}" class="btn btn-info">
                                  <i class="fa fa-eye" aria-hidden="true"></i>
                                </a>
                                <a href="{{ route('playlist.edit', $item->id) }}" class="btn btn-warning">
                                <i class="fa fa-pencil" aria-hidden="true"></i>
                                </a>
                                <form action="{{ route('playlist.destroy', $item->id) }}" method="POST" style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger" onclick="return confirm('Tem certeza que deseja excluir esta playlist?')"> <i class="fa-solid fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
<style>

#playlist_filter input {
    display: block;
    width: 100%;
    height: calc(1.5em + .75rem + 2px);
    padding: .375rem .75rem;
    font-size: 1rem;
    font-weight: 400;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da !important;
    border-radius: .25rem;
    transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
}
.dataTables_paginate a{
    padding:5px;
    background:#007bff;
    color:#fff;
    margin-right:10px;
    cursor:pointer;
    margin-top:10px;
}

#playlist_length select {
   
        background-position-x: 0%;
        background-position-y: 0%;
        color:#000;
    background-position: 205px center;
    width: 270px;
    height: 48px;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 18px;
    padding: 13px 20px 13px 12px;

    text-indent: 0.01px;
    text-overflow: "";
    select: :-ms-expand {display: none;};
}
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" src="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
	   
	 
<script type="text/javascript" language="javascript" class="init">
var j = jQuery.noConflict();
j(document).ready(function() {
	j('#playlist').dataTable({
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados por página",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });
});
</script>
@endsection
