<!-- resources/views/playlist/create.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Criar Nova Playlist</h3>
        </div>
        <div class="card-body">
        
            <form id="playlist-form">
                @csrf
                <input type="hidden" name="user_id" value="{{Auth::user()->id}}">
                <div class="form-group">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" placeholder="Título da playlist" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" placeholder="Descrição da playlist" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label for="embed">Foto de capa</label>
                    <input type="file" name="image" class="form-control-file">
                </div>
                <div class="form-group">
                    <label for="embed">Arquivo de mídia</label>
                    <input type="file" name="embled" class="form-control-file" >
                </div>
                <div class="errors"></div>
                <div class="form-group buttons">
                    <button type="submit" class="btn btn-success">Salvar
                      <div class="spinner" style="visibility: hidden;"></div>
                    </button>
                    <a href="{{ route('playlist.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
                
            </form>
        </div>
    </div>
</div>
<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
  
    $('#playlist-form').on('submit', function (e) {
        e.preventDefault(); 
        $('.spinner').css('visibility', 'visible');
        var formData = new FormData(this);
        
        $.ajax({
            url: "{{ route('playlist.store') }}", // Rota para criar a playlist
            type: "POST",
            data: formData,
            processData: false,
            contentType: false
        })
        .done(function (response) {
            if (response.response == 201) {
                $('.errors').html('<div class="alert alert-success">Playlist criada com sucesso.</div>');
                window.location.href = "{{ route('playlist.index') }}";
            } else {
                $('.errors').html('<div class="alert alert-danger">Erro ao criar a playlist.</div>');
            }
        })
        .fail(function (xhr) {
            $('.errors').html('<div class="alert alert-danger">Erro ao criar playlist. Tente novamente.</div>');
        })
        .always(function () {
            $('.spinner').css('visibility', 'hidden');
        });
    });
});
</script>
@endsection
