<!-- resources/views/news/show.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Detalhes do Post</h3>
            <a href="{{ route('news.index') }}" class="btn btn-secondary float-right">Voltar</a>
        </div>
        <div class="card-body">
            <h4>Título: {{ $news->title }}</h4>
            <p><strong>Descrição:</strong></p>
            <p>{{ $news->description }}</p>
            @if ($news->image)
                <p><strong>Imagem:</strong></p>
                <img src="{{ asset('storage/' . $news->image) }}" width="300">
            @endif
            <p><strong>Criado em:</strong> {{ $news->created_at->format('d/m/Y') }}</p>
        </div>
    </div>
</div>
@endsection
