<!-- resources/views/news/edit.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Editar Post</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('news.update', $news->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <input type="hidden" name="users_id" value="{{ Auth::user()->id}}">
                    <label for="title">Título</label>
                    <input type="text" name="title" class="form-control" value="{{ $news->title }}" required>
                </div>
                <div class="form-group">
                    <label for="description">Descrição</label>
                    <textarea name="description" class="form-control" rows="5" required>{{ $news->description }}</textarea>
                </div>
                <div class="form-group">
                    <label for="image">Imagem (opcional)</label>
                    <input type="file" name="image" class="form-control-file">
                </div>
                @if ($news->image)
                    <div class="form-group">
                        <p><strong>Imagem Atual:</strong></p>
                        <img src="{{ asset('storage/' . $news->image) }}" width="100">
                    </div>
                @endif
                <br>
                <div class="errors"></div>
                <div class="form-group">
                    <button type="submit" class="btn btn-success">Atualizar    <span class="spinner" style="visibility: hidden;"></span> </button>
                    <a href="{{ route('news.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
<style>

    /* Spinner CSS */
.spinner {
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-right: 8px; /* Espaçamento entre o spinner e o texto */
    display: inline-block;
    vertical-align: middle;
    }
    .btn{
        padding:5px 30px 5px 51px;
    }
    .btn-danger:hover{
        border-color: none !important;
    }
    
    @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
 }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    
$(document).ready(function () {
   
    // Capturar o evento de submissão do formulário
    $('form').on('submit', function (e) {
        e.preventDefault(); // Prevenir a submissão padrão do formulário
        $('.spinner').css('visibility', 'visible');    
        // Mostrar o indicador de carregamento (exemplo de spinner)
        let loadingIndicator = $('<div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div>');
        $('.buttons').append(loadingIndicator);

        // Criar um FormData com os dados do formulário
        var formData = new FormData(this);
        var id = "{{ $news['id'] ?? '' }}"; // Ou definir manualmente, caso esteja disponível
        //alert(id);
        // Enviar o formulário via AJAX
        $.ajax({
            url: "{{ url('/news') }}/" + id, // Rota para onde enviar os dados
            type: "POST",
            data: formData,
            processData: false,  // Necessário para enviar FormData
            contentType: false   // Necessário para enviar FormData
        })
        .done(function (response) {
           

           // alert(response.response);

            if (response.response == 200) {
                var  id = response[1];
                $('.errors').html('');
                $('.errors').append('<div class="alert alert-success">Postagem atualizada com sucesso.</div>');
                 window.location.href = "{{ route('news.index') }}"; 
                //window.location.reload();
            } else {
                 $('.errors').html('');
                    
                 for (let i = 0; i < count; i++) {
                        $('.errors').append("<div class='alert alert-danger'>" + response[0][i] + "</div>" );
                 } 
            }

   
        })
        .fail(function (xhr) {
            // Lidar com o erro (podes mostrar uma mensagem de erro)
            let successMessage = $('<div class="alert alert-danger">Erro ao criar postagem, por favor tente novamente.!</div>');
            $('.errors').html(successMessage)
        })
        .always(function () {
            // Remover o indicador de carregamento
           
            $('.spinner').css('visibility', 'hidden');    
            // Opcional: redefinir o texto do botão ou qualquer outro estado
            // $('.finalize-form').text('deu');
        });
    });
});
</script>
@endsection
