<!-- resources/views/photos/show.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3>Detalhes da Categoria</h3>
            <a href="{{ route('category.index') }}" class="btn btn-secondary float-right">Voltar</a>
        </div>
        <div class="card-body">
            <h4>Título: {{ $category->title }}</h4>
            <p><strong>Descrição:</strong></p>
            <p>{{ $category->description }}</p>
            <p><strong>Imagem:</strong></p>
            <div><img src="{{ asset('storage/' . $category->image) }}" alt="{{ $category->title }}" width="200"></div>
            <p><strong>Criado em:</strong> {{{ \Carbon\Carbon::parse($category->created_at)->format('d/m/Y') }}}</p>
        </div>
    </div>
</div>
@endsection