<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    use HasFactory;

    protected $table = 'schedule';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

	protected $fillable = [
        'title',
        'description',
        'date',
        'deleted',
        'users_id',
        'image',
        'location'
    ];

    
    protected $timestamp = true;
}


/*
CREATE TABLE schedule (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  users_id INTEGER UNSIGNED NOT NULL,
  title VARCHAR(100) NULL,
  description VARCHAR(500) NULL,
  date DATETIME NULL,
  image TEXT NULL,
  location varchar(300) NULL,
  deleted CHAR(1) NULL,
  updated_at TIMESTAMP NULL,
  created_at TIMESTAMP NULL,
  PRIMARY KEY(id),
  INDEX schedule_FKIndex1(users_id)
);

*/